<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<div id="ccwpm-modal-dialog-<?php echo esc_attr( $modal ); ?>" class="ccwpm-modal-dialog">
	<div class="ccwpm-modal-container">
		<h2><?php _e( 'Enter your Purchase ID', CCWPM_PLUGIN_NAME ); ?></h2>
		<p><?php _e( 'To update your plugin/extension to the latest version, please fill your Purchase ID below.', CCWPM_PLUGIN_NAME ); ?></p>
		<p class="ccwpm-modal-error"></p>
		<p>
			<input type="text" class="ccwpm-purchase-id" placeholder="<?php _e( 'Purchase ID', CCWPM_PLUGIN_NAME ); ?>" />
			<input type="hidden" class="ccwpm-update-link" value="<?php echo esc_url( $url ); ?>" />
		</p>
		<p>
			<?php _e( "Don't have a Purchase ID? You can find your Purchase ID", CCWPM_PLUGIN_NAME ); ?>
			<a href="https://ccwpmigration.xyz/lost-purchase" target="_blank" class="ccwpm-help-link"><?php _e( 'here', CCWPM_PLUGIN_NAME ); ?></a>
		</p>
		<p class="ccwpm-modal-buttons submitbox">
			<button type="button" class="ccwpm-purchase-add ccwpm-button-green">
				<?php _e( 'Save', CCWPM_PLUGIN_NAME ); ?>
			</button>
			<a href="#" class="submitdelete ccwpm-purchase-discard"><?php _e( 'Discard', CCWPM_PLUGIN_NAME ); ?></a>
		</p>
	</div>
</div>

<span id="ccwpm-update-section-<?php echo esc_attr( $modal ); ?>">
	<i class="ccwpm-icon-update"></i>
	<?php _e( 'There is an update available. To update, you must enter your', CCWPM_PLUGIN_NAME ); ?>
	<a href="#ccwpm-modal-dialog-<?php echo esc_attr( $modal ); ?>"><?php _e( 'Purchase ID', CCWPM_PLUGIN_NAME ); ?></a>.
</span>
