<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<?php if ( is_readable( CCWPM_STORAGE_PATH ) && is_writable( CCWPM_STORAGE_PATH ) ) : ?>
	<div class="ccwpm-import-messages"></div>

	<div class="ccwpm-import-form">
		<div class="hide-if-no-js">
			<div class="ccwpm-drag-drop-area" id="ccwpm-drag-drop-area">
				<div id="ccwpm-import-init">
					<p>
						<i class="ccwpm-icon-cloud-upload"></i><br />
						<?php _e( 'Drag & Drop to upload', CCWPM_PLUGIN_NAME ); ?>
					</p>
					<div class="ccwpm-button-group ccwpm-button-import ccwpm-expandable">
						<div class="ccwpm-button-main">
							<span><?php _e( 'Import From', CCWPM_PLUGIN_NAME ); ?></span>
							<span class="ai1mw-lines">
								<span class="ccwpm-line ccwpm-line-first"></span>
								<span class="ccwpm-line ccwpm-line-second"></span>
								<span class="ccwpm-line ccwpm-line-third"></span>
							</span>
						</div>
						<ul class="ccwpm-dropdown-menu ccwpm-import-providers">
							<?php foreach ( apply_filters( 'ccwpm_import_buttons', array() ) as $button ) : ?>
								<li>
									<?php echo $button; ?>
								</li>
							<?php endforeach; ?>
						</ul>
					</div>
				</div>
			</div>
		</div>
	</div>

	<p>
		<?php _e( 'Maximum upload file size:' ); ?>
		<?php if ( ( $max_file_size = apply_filters( 'ccwpm_max_file_size', CCWPM_MAX_FILE_SIZE ) ) ) : ?>
			<span class="ccwpm-max-upload-size"><?php echo size_format( $max_file_size ); ?></span>

		<?php else : ?>
			<span class="ccwpm-max-upload-size"><?php _e( 'Unlimited', CCWPM_PLUGIN_NAME ); ?></span>
		<?php endif; ?>
	</p>
<?php else : ?>
	<div class="ccwpm-message ccwpm-red-message">
		<?php
		printf(
			__(
				'<h3>Site could not be imported!</h3>' .
				'<p>Please make sure that storage directory <strong>%s</strong> has read and write permissions.</p>',
				CCWPM_PLUGIN_NAME
			),
			CCWPM_STORAGE_PATH
		);
		?>
	</div>
<?php endif; ?>
