<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<div class="ccwpm-field-set">
	<div class="ccwpm-accordion ccwpm-expandable">
		<h4>
			<i class="ccwpm-icon-arrow-right"></i>
			<?php _e( 'Advanced options', CCWPM_PLUGIN_NAME ); ?>
			<small><?php _e( '(click to expand)', CCWPM_PLUGIN_NAME ); ?></small>
		</h4>
		<ul>
			<li>
				<label for="ccwpm-no-spam-comments">
					<input type="checkbox" id="ccwpm-no-spam-comments" name="options[no_spam_comments]" />
					<?php _e( 'Do <strong>not</strong> export spam comments', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>
			<li>
				<label for="ccwpm-no-post-revisions">
					<input type="checkbox" id="ccwpm-no-post-revisions" name="options[no_post_revisions]" />
					<?php _e( 'Do <strong>not</strong> export post revisions', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>
			<li>
				<label for="ccwpm-no-media">
					<input type="checkbox" id="ccwpm-no-media" name="options[no_media]" />
					<?php _e( 'Do <strong>not</strong> export media library (files)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>
			<li>
				<label for="ccwpm-no-themes">
					<input type="checkbox" id="ccwpm-no-themes" name="options[no_themes]" />
					<?php _e( 'Do <strong>not</strong> export themes (files)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>

			<?php if ( apply_filters( 'ccwpm_max_file_size', CCWPM_MAX_FILE_SIZE ) === 0 ) : ?>
				<li>
					<label for="ccwpm-no-inactive-themes">
						<input type="checkbox" id="ccwpm-no-inactive-themes" name="options[no_inactive_themes]" />
						<?php _e( 'Do <strong>not</strong> export inactive themes (files)', CCWPM_PLUGIN_NAME ); ?>
						<small style="color: red;"><?php _e( 'new', CCWPM_PLUGIN_NAME ); ?></small>
					</label>
				</li>
			<?php endif; ?>

			<li>
				<label for="ccwpm-no-muplugins">
					<input type="checkbox" id="ccwpm-no-muplugins" name="options[no_muplugins]" />
					<?php _e( 'Do <strong>not</strong> export must-use plugins (files)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>

			<li>
				<label for="ccwpm-no-plugins">
					<input type="checkbox" id="ccwpm-no-plugins" name="options[no_plugins]" />
					<?php _e( 'Do <strong>not</strong> export plugins (files)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>

			<?php if ( apply_filters( 'ccwpm_max_file_size', CCWPM_MAX_FILE_SIZE ) === 0 ) : ?>
				<li>
					<label for="ccwpm-no-inactive-plugins">
						<input type="checkbox" id="ccwpm-no-inactive-plugins" name="options[no_inactive_plugins]" />
						<?php _e( 'Do <strong>not</strong> export inactive plugins (files)', CCWPM_PLUGIN_NAME ); ?>
						<small style="color: red;"><?php _e( 'new', CCWPM_PLUGIN_NAME ); ?></small>
					</label>
				</li>
				<li>
					<label for="ccwpm-no-cache">
						<input type="checkbox" id="ccwpm-no-cache" name="options[no_cache]" />
						<?php _e( 'Do <strong>not</strong> export cache (files)', CCWPM_PLUGIN_NAME ); ?>
						<small style="color: red;"><?php _e( 'new', CCWPM_PLUGIN_NAME ); ?></small>
					</label>
				</li>
			<?php endif; ?>

			<li>
				<label for="ccwpm-no-database">
					<input type="checkbox" id="ccwpm-no-database" name="options[no_database]" />
					<?php _e( 'Do <strong>not</strong> export database (sql)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>
			<li>
				<label for="ccwpm-no-email-replace">
					<input type="checkbox" id="ccwpm-no-email-replace" name="options[no_email_replace]" />
					<?php _e( 'Do <strong>not</strong> replace email domain (sql)', CCWPM_PLUGIN_NAME ); ?>
				</label>
			</li>

			<?php do_action( 'ccwpm_export_advanced_settings' ); ?>
		</ul>
	</div>
</div>
