<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<div class="ccwpm-report-problem">
	<button type="button" id="ccwpm-report-problem-button" class="ccwpm-button-red">
		<i class="ccwpm-icon-notification"></i>
		<?php _e( 'Report issue', CCWPM_PLUGIN_NAME ); ?>
	</button>
	<div class="ccwpm-report-problem-dialog">
		<div class="ccwpm-field">
			<input placeholder="<?php _e( 'Enter your email address..', CCWPM_PLUGIN_NAME ); ?>" type="text" id="ccwpm-report-email" class="ccwpm-report-email" />
		</div>
		<div class="ccwpm-field">
			<textarea rows="3" id="ccwpm-report-message" class="ccwpm-report-message" placeholder="<?php _e( 'Please describe your problem here..', CCWPM_PLUGIN_NAME ); ?>"></textarea>
		</div>
		<div class="ccwpm-field ccwpm-report-terms-segment">
			<label for="ccwpm-report-terms">
				<input type="checkbox" class="ccwpm-report-terms" id="ccwpm-report-terms" />
				<?php _e( 'I agree that by filling in the contact form with my data, I authorize CC WP Migration to use my <strong>email</strong> to reply to my requests for information. <a href="https://www.iubenda.com/privacy-policy/946881" target="_blank">Privacy policy</a>', CCWPM_PLUGIN_NAME ); ?>
			</label>
		</div>
		<div class="ccwpm-field">
			<div class="ccwpm-buttons">
				<a href="#" id="ccwpm-report-cancel" class="ccwpm-report-cancel"><?php _e( 'Cancel', CCWPM_PLUGIN_NAME ); ?></a>
				<button type="submit" id="ccwpm-report-submit" class="ccwpm-button-blue ccwpm-form-submit">
					<i class="ccwpm-icon-paperplane"></i>
					<?php _e( 'Send', CCWPM_PLUGIN_NAME ); ?>
				</button>
				<span class="spinner"></span>
				<div class="ccwpm-clear"></div>
			</div>
		</div>
	</div>
</div>
