<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<div class="ccwpm-feedback">
	<ul class="ccwpm-feedback-types">
		<li>
			<input type="radio" class="ccwpm-flat-radio-button ccwpm-feedback-type" id="ccwpm-feedback-type-1" name="ccwpm_feedback_type" value="review" />
			<a id="ccwpm-feedback-type-link-1" href="https://wordpress.org/support/view/plugin-reviews/cc-wp-migration?rate=5#postform" target="_blank">
				<i></i>
				<span><?php _e( 'I would like to review this plugin', CCWPM_PLUGIN_NAME ); ?></span>
			</a>
		</li>
		<li>
			<input type="radio" class="ccwpm-flat-radio-button ccwpm-feedback-type" id="ccwpm-feedback-type-2" name="ccwpm_feedback_type" value="suggestions" />
			<a id="ccwpm-feedback-type-link-2" href="https://feedback.wp-migration.com" target="_blank">
				<i></i>
				<span><?php _e( 'I have ideas to improve this plugin', CCWPM_PLUGIN_NAME ); ?></span>
			</a>
		</li>
		<li>
			<input type="radio" class="ccwpm-flat-radio-button ccwpm-feedback-type" id="ccwpm-feedback-type-3" name="ccwpm_feedback_type" value="help-needed" />
			<label for="ccwpm-feedback-type-3">
				<i></i>
				<span><?php _e( 'I need help with this plugin', CCWPM_PLUGIN_NAME ); ?></span>
			</label>
		</li>
	</ul>

	<div class="ccwpm-feedback-form">
		<div class="ccwpm-field">
			<input placeholder="<?php _e( 'Enter your email address..', CCWPM_PLUGIN_NAME ); ?>" type="text" id="ccwpm-feedback-email" class="ccwpm-feedback-email" />
		</div>
		<div class="ccwpm-field">
			<textarea rows="3" id="ccwpm-feedback-message" class="ccwpm-feedback-message" placeholder="<?php _e( 'Leave plugin developers any feedback here..', CCWPM_PLUGIN_NAME ); ?>"></textarea>
		</div>
		<div class="ccwpm-field ccwpm-feedback-terms-segment">
			<label for="ccwpm-feedback-terms">
				<input type="checkbox" class="ccwpm-feedback-terms" id="ccwpm-feedback-terms" />
				<?php _e( 'I agree that by filling in the contact form with my data, I authorize CC WP Migration to use my <strong>email</strong> to reply to my requests for information. <a href="https://www.iubenda.com/privacy-policy/946881" target="_blank">Privacy policy</a>', CCWPM_PLUGIN_NAME ); ?>
			</label>
		</div>
		<div class="ccwpm-field">
			<div class="ccwpm-buttons">
				<a class="ccwpm-feedback-cancel" id="ccwpm-feedback-cancel" href="#"><?php _e( 'Cancel', CCWPM_PLUGIN_NAME ); ?></a>
				<button type="submit" id="ccwpm-feedback-submit" class="ccwpm-button-blue ccwpm-form-submit">
					<i class="ccwpm-icon-paperplane"></i>
					<?php _e( 'Send', CCWPM_PLUGIN_NAME ); ?>
				</button>
				<span class="spinner"></span>
				<div class="ccwpm-clear"></div>
			</div>
		</div>
	</div>
</div>
