<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
?>

<div class="ccwpm-container">

			<div class="ccwpm-holder">
				<h1>
					<i class="ccwpm-icon-export"></i>
					<?php _e( 'Backups', CCWPM_PLUGIN_NAME ); ?>
				</h1>



				<form action="" method="post" id="ccwpm-backups-form" class="ccwpm-clear">

					<?php if ( is_readable( CCWPM_BACKUPS_PATH ) && is_writable( CCWPM_BACKUPS_PATH ) ) : ?>
						<?php if ( $backups ) : ?>
							<table class="ccwpm-backups">
								<thead>
									<tr>
										<th class="ccwpm-column-name"><?php _e( 'Name', CCWPM_PLUGIN_NAME ); ?></th>
										<th class="ccwpm-column-date"><?php _e( 'Date', CCWPM_PLUGIN_NAME ); ?></th>
										<th class="ccwpm-column-size"><?php _e( 'Size', CCWPM_PLUGIN_NAME ); ?></th>
										<th class="ccwpm-column-actions"></th>
									</tr>
								</thead>
								<tbody>
									<?php foreach ( $backups as $backup ) : ?>
									<tr>
										<td class="ccwpm-column-name">
											<?php if ( $backup['path'] ) : ?>
												<i class="ccwpm-icon-folder"></i>
												<?php echo esc_html( $backup['path'] ); ?>
												<br />
											<?php endif; ?>
											<i class="ccwpm-icon-file-zip"></i>
											<?php echo esc_html( basename( $backup['filename'] ) ); ?>
										</td>
										<td class="ccwpm-column-date">
											<?php echo esc_html( sprintf( __( '%s ago', CCWPM_PLUGIN_NAME ), human_time_diff( $backup['mtime'] ) ) ); ?>
										</td>
										<td class="ccwpm-column-size">
											<?php if ( is_null( $backup['size'] ) ) : ?>
												<?php _e( '2GB+', CCWPM_PLUGIN_NAME ); ?>
											<?php else : ?>
												<?php echo size_format( $backup['size'], 2 ); ?>
											<?php endif; ?>
										</td>
										<td class="ccwpm-column-actions ccwpm-backup-actions">
											<a href="<?php echo ccwpm_backup_url( array( 'archive' => esc_attr( $backup['filename'] ) ) ); ?>" class="ccwpm-button-green ccwpm-backup-download">
												<i class="ccwpm-icon-arrow-down"></i>
												<span><?php _e( 'Download', CCWPM_PLUGIN_NAME ); ?></span>
											</a>
											<a href="#" data-archive="<?php echo esc_attr( $backup['filename'] ); ?>" class="ccwpm-button-gray ccwpm-backup-restore">
												<i class="ccwpm-icon-cloud-upload"></i>
												<span><?php _e( 'Restore', CCWPM_PLUGIN_NAME ); ?></span>
											</a>
											<a href="#" data-archive="<?php echo esc_attr( $backup['filename'] ); ?>" class="ccwpm-button-red ccwpm-backup-delete">
												<i class="ccwpm-icon-close"></i>
												<span><?php _e( 'Delete', CCWPM_PLUGIN_NAME ); ?></span>
											</a>
										</td>
									</tr>
									<?php endforeach; ?>
								</tbody>
							</table>
						<?php endif; ?>
						<div class="ccwpm-backups-create">
							<p class="ccwpm-backups-empty <?php echo $backups ? 'ccwpm-hide' : null; ?>">
								<?php _e( 'There are no backups available at this time, why not create a new one?', CCWPM_PLUGIN_NAME ); ?>
							</p>
							<p>
								<a href="<?php echo esc_url( network_admin_url( 'admin.php?page=ccwpm_export' ) ); ?>" class="ccwpm-button-green">
									<i class="ccwpm-icon-export"></i>
									<?php _e( 'Create backup', CCWPM_PLUGIN_NAME ); ?>
								</a>
							</p>
						</div>
					<?php else : ?>
						<div class="ccwpm-clear ccwpm-message ccwpm-red-message">
							<?php
							printf(
								__(
									'<h3>Site could not create backups!</h3>' .
									'<p>Please make sure that storage directory <strong>%s</strong> has read and write permissions.</p>',
									CCWPM_PLUGIN_NAME
								),
								CCWPM_STORAGE_PATH
							);
							?>
						</div>
					<?php endif; ?>

					<?php do_action( 'ccwpm_backups_left_end' ); ?>

					<input type="hidden" name="ccwpm_manual_restore" value="1" />

				</form>
			</div>

</div>
