/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 83);
/******/ })
/************************************************************************/
/******/ ({

/***/ 83:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function ($) {
	'use strict';

	$('.ccwpm-purchase-add').click(function (e) {
		var self = $(this);

		self.attr('disabled', true);

		var dialog = self.closest('.ccwpm-modal-dialog');
		var error = dialog.find('.ccwpm-modal-error');
		var index = dialog.attr('id').split('-').pop();
		var purchaseId = dialog.find('.ccwpm-purchase-id').val();
		var updateLink = dialog.find('.ccwpm-update-link').val();

		// Check Purchase ID
		$.ajax({
			url: 'https://ccwpmigration.xyz/purchase/' + purchaseId + '/check',
			type: 'GET',
			dataType: 'json',
			dataFilter: function dataFilter(data, type) {
				return CCwpm.Util.json(data);
			}
		}).done(function (product) {
			// Update Purchase ID
			$.ajax({
				url: ccwpm_updater.ajax.url,
				type: 'POST',
				dataType: 'json',
				data: {
					'ccwpm_uuid': product.uuid,
					'ccwpm_extension': product.extension
				},
				dataFilter: function dataFilter(data, type) {
					return CCwpm.Util.json(data);
				}
			}).done(function () {
				window.location.hash = '';

				// Update plugin row
				$('#ccwpm-update-section-' + index).html($('<a />').attr('href', updateLink).text(ccwpm_locale.check_for_updates));

				self.attr('disabled', false);
			});
		}).fail(function () {
			self.attr('disabled', false);
			error.html(ccwpm_locale.invalid_purchase_id);
		});

		e.preventDefault();
	});

	$('.ccwpm-purchase-discard').click(function (e) {
		window.location.hash = '';

		e.preventDefault();
	});
});

/***/ })

/******/ });