/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 40);
/******/ })
/************************************************************************/
/******/ ({

/***/ 0:
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ 3:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function ($) {
	'use strict';

	// Review

	$('#ccwpm-feedback-type-link-1').click(function (e) {
		var radio = $('#ccwpm-feedback-type-1');
		if (radio.is(':checked')) {
			radio.attr('checked', false);
		} else {
			radio.attr('checked', true);
		}
	});

	// Idea
	$('#ccwpm-feedback-type-link-2').click(function (e) {
		var radio = $('#ccwpm-feedback-type-2');
		if (radio.is(':checked')) {
			radio.attr('checked', false);
		} else {
			radio.attr('checked', true);
		}
	});

	// Help
	$('#ccwpm-feedback-type-3').click(function () {
		// Hide other options
		$('#ccwpm-feedback-type-1, #ccwpm-feedback-type-2').closest('li').hide();

		// Change placeholder message
		$('.ccwpm-feedback-form').find('.ccwpm-feedback-message').attr('placeholder', ccwpm_locale.how_may_we_help_you);

		// Show feedback form
		$('.ccwpm-feedback-form').fadeIn();
	});

	// Cancel feedback form
	$('#ccwpm-feedback-cancel').click(function (e) {
		$('.ccwpm-feedback-form').fadeOut(function () {
			$('.ccwpm-feedback-type').attr('checked', false).closest('li').show();
		});

		e.preventDefault();
	});

	// Send feedback form
	$('#ccwpm-feedback-submit').click(function (e) {
		var self = $(this);

		var spinner = self.next();
		var type = $('.ccwpm-feedback-type:checked').val();
		var email = $('.ccwpm-feedback-email').val();
		var message = $('.ccwpm-feedback-message').val();
		var terms = $('.ccwpm-feedback-terms').is(':checked');

		self.attr('disabled', true);
		spinner.css('visibility', 'visible');

		$.ajax({
			url: ccwpm_feedback.ajax.url,
			type: 'POST',
			dataType: 'json',
			async: true,
			data: {
				'secret_key': ccwpm_feedback.secret_key,
				'ccwpm_type': type,
				'ccwpm_email': email,
				'ccwpm_message': message,
				'ccwpm_terms': +terms
			},
			dataFilter: function dataFilter(data, type) {
				return CCwpm.Util.json(data);
			}
		}).done(function (data) {
			self.attr('disabled', false);
			spinner.css('visibility', 'hidden');

			if (data.errors.length > 0) {
				$('.ccwpm-feedback .ccwpm-message').remove();

				var errorMessage = $('<div />').addClass('ccwpm-message ccwpm-error-message');
				$.each(data.errors, function (key, value) {
					errorMessage.append($('<p />').text(value));
				});

				$('.ccwpm-feedback').prepend(errorMessage);
			} else {
				var successMessage = $('<div />').addClass('ccwpm-message ccwpm-success-message');
				successMessage.append($('<p />').text(ccwpm_locale.thanks_for_submitting_your_feedback));

				$('.ccwpm-feedback').html(successMessage);
			}
		});

		e.preventDefault();
	});
});

/***/ }),

/***/ 4:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function ($) {
	'use strict';

	$('#ccwpm-report-problem-button').click(function (e) {
		$(this).next('.ccwpm-report-problem-dialog').toggleClass('ccwpm-report-active');

		e.preventDefault();
	});

	$('#ccwpm-report-cancel').click(function (e) {
		$(this).closest('.ccwpm-report-problem-dialog').removeClass('ccwpm-report-active');

		e.preventDefault();
	});

	$('#ccwpm-report-submit').click(function (r) {
		var self = $(this);

		var spinner = self.next();
		var email = $('.ccwpm-report-email').val();
		var message = $('.ccwpm-report-message').val();
		var terms = $('.ccwpm-report-terms').is(':checked');

		self.attr('disabled', true);
		spinner.css('visibility', 'visible');

		$.ajax({
			url: ccwpm_report.ajax.url,
			type: 'POST',
			dataType: 'json',
			async: true,
			data: {
				'secret_key': ccwpm_report.secret_key,
				'ccwpm_email': email,
				'ccwpm_message': message,
				'ccwpm_terms': +terms
			},
			dataFilter: function dataFilter(data, type) {
				return CCwpm.Util.json(data);
			}
		}).done(function (data) {
			self.attr('disabled', false);
			spinner.css('visibility', 'hidden');

			if (data.errors.length > 0) {
				$('.ccwpm-report-problem-dialog .ccwpm-message').remove();

				var errorMessage = $('<div />').addClass('ccwpm-message ccwpm-error-message');
				$.each(data.errors, function (key, value) {
					errorMessage.append($('<p />').text(value));
				});

				$('.ccwpm-report-problem-dialog').prepend(errorMessage);
			} else {
				var successMessage = $('<div />').addClass('ccwpm-message ccwpm-success-message');
				successMessage.append($('<p />').text(ccwpm_locale.thanks_for_submitting_your_request));

				$('.ccwpm-report-problem-dialog').html(successMessage);

				// Hide message
				setTimeout(function () {
					$('.ccwpm-report-problem-dialog').removeClass('ccwpm-report-active');
				}, 2000);
			}
		});

		e.preventDefault();
	});
});

/***/ }),

/***/ 40:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Query = __webpack_require__(41),
    FindReplace = __webpack_require__(42),
    Feedback = __webpack_require__(3),
    Report = __webpack_require__(4),
    Export = __webpack_require__(43);

jQuery(document).ready(function ($) {
	'use strict';

	var model = new Export();

	// Export to file
	$('#ccwpm-export-file').click(function (e) {
		var storage = CCwpm.Util.random(12);
		var options = CCwpm.Util.form('#ccwpm-export-form').concat({ name: 'storage', value: storage });

		// Set global params
		model.setParams(options);

		// Start export
		model.start();

		e.preventDefault();
	});

	$('.ccwpm-accordion > .ccwpm-title').click(function () {
		$(this).parent().toggleClass('ccwpm-active');
	});

	$('#ccwpm-add-new-replace-button').ccwpm_find_replace();

	$('.ccwpm-expandable > p:first, .ccwpm-expandable > h4:first, .ccwpm-expandable > div.ccwpm-button-main').on('click', function () {
		$(this).parent().toggleClass('ccwpm-open');
	});

	$('.ccwpm-query').ccwpm_query();
});

global.CCwpm = jQuery.extend({}, global.CCwpm, { Query: Query, FindReplace: FindReplace, Feedback: Feedback, Report: Report, Export: Export });
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0)))

/***/ }),

/***/ 41:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

;(function ($) {

  $.fn.ccwpm_query = function () {
    var findInput = $(this).find('input.ccwpm-query-find-input'),
        replaceInput = $(this).find('input.ccwpm-query-replace-input'),
        findText = $(this).find('small.ccwpm-query-find-text'),
        replaceText = $(this).find('small.ccwpm-query-replace-text');

    findInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<text>';
      findText.text(_inputValue);
    });

    replaceInput.on('change paste input keypress keydown keyup', function () {
      var _inputValue = $(this).val().length > 0 ? $(this).val() : '<another-text>';
      replaceText.text(_inputValue);
    });

    return this;
  };
})(jQuery);

/***/ }),

/***/ 42:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

;(function ($) {

  $.fn.ccwpm_find_replace = function () {
    $(this).click(function (e) {
      e.preventDefault();

      var row = $('#ccwpm-queries > li:first').clone();

      // Reset input values
      row.find('input').val('');

      // Reset ccwpm-query-find-text
      row.find('.ccwpm-query-find-text').html('&lt;text&gt;');

      // Reset ccwpm-query-replace-text
      row.find('.ccwpm-query-replace-text').html('&lt;another-text&gt;');

      $('#ccwpm-queries > li').removeClass('ccwpm-open');

      $(row).addClass('ccwpm-open');

      // Add new replace fields
      $('#ccwpm-queries').append(row);
      $(row).ccwpm_query();
      $(row).find('p:first').on('click', function () {
        $(this).parent().toggleClass('ccwpm-open');
      });
    });

    return this;
  };
})(jQuery);

/***/ }),

/***/ 43:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Modal = __webpack_require__(44),
    $ = jQuery;

var Export = function Export() {
	var self = this;

	// Set params
	this.params = [];

	// Set stop flag
	this.stopExport = false;

	// Set modal
	this.modal = new Modal();

	// Set stop listener
	this.modal.onStop = function (options) {
		self.onStop(options);
	};
};

Export.prototype.setParams = function (params) {
	this.params = CCwpm.Util.list(params);
};

Export.prototype.start = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Set stop flag
	if (retries === 0) {
		this.stopExport = false;
	}

	// Stop running export
	if (this.stopExport) {
		return;
	}

	// Initializing beforeunload event
	$(window).bind('beforeunload', function () {
		return ccwpm_locale.stop_exporting_your_website;
	});

	// Set initial status
	this.setStatus({ type: 'info', message: ccwpm_locale.preparing_to_export });

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_export.secret_key });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Export
	$.ajax({
		url: ccwpm_export.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		self.getStatus();
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_export,
				message: ccwpm_locale.unable_to_start_the_export
			});
		}

		retries++;

		setTimeout(self.start.bind(self, options, retries), timeout);
	});
};

Export.prototype.run = function (params, retries) {
	var self = this;
	var retries = retries || 0;

	// Stop running export
	if (this.stopExport) {
		return;
	}

	// Export
	$.ajax({
		url: ccwpm_export.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_export,
				message: ccwpm_locale.unable_to_run_the_export
			});
		}

		retries++;

		setTimeout(self.run.bind(self, params, retries), timeout);
	});
};

Export.prototype.clean = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Set stop flag
	this.stopExport = true;

	// Set initial status
	this.setStatus({ type: 'info', message: ccwpm_locale.please_wait_stopping_the_export });

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_export.secret_key }).concat({ name: 'priority', value: 300 });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Clean
	$.ajax({
		url: ccwpm_export.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		// Unbinding the beforeunload event when we stop exporting
		$(window).unbind('beforeunload');

		// Destroy modal
		self.modal.destroy();
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_export,
				message: ccwpm_locale.unable_to_stop_the_export
			});
		}

		retries++;

		setTimeout(self.clean.bind(self, options, retries), timeout);
	});
};

Export.prototype.getStatus = function () {
	var self = this;

	// Stop getting status
	if (this.stopExport) {
		return;
	}

	$.ajax({
		url: ccwpm_export.status.url,
		type: 'GET',
		dataType: 'json',
		cache: false,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function (params) {
		if (params) {
			self.setStatus(params);

			// Next status
			switch (params.type) {
				case 'done':
				case 'error':
				case 'download':
					// Unbinding beforeunload event when any case is performed
					$(window).unbind('beforeunload');
					return;
			}
		}

		// Export is not done yet, let's check status in 3 seconds
		setTimeout(self.getStatus.bind(self), 3000);
	}).fail(function () {
		// Export is not done yet, let's check status in 3 seconds
		setTimeout(self.getStatus.bind(self), 3000);
	});
};

Export.prototype.setStatus = function (params) {
	this.modal.render(params);
};

Export.prototype.onStop = function (options) {
	this.clean(options);
};

module.exports = Export;

/***/ }),

/***/ 44:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var $ = jQuery;

var Modal = function Modal() {
	var self = this;

	// Error Modal
	this.error = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create title
		var title = $('<span></span>').addClass('ccwpm-title-red').text(params.title);

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			self.destroy();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_export);

		// Append close button to action
		action.append(closeButton);

		// Append title to section
		header.append(title);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Info Modal
	this.info = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold loader
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create loader
		var loader = $('<span class="ccwpm-loader"></span>');

		// Create stop export
		var stopButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			$(this).attr('disabled', 'disabled');
			self.onStop();
		});

		// Append text to stop button
		stopButton.append('<i class="ccwpm-icon-notification"></i> ' + ccwpm_locale.stop_export);

		// Append stop button to action
		action.append(stopButton);

		// Append loader to header
		header.append(loader);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Done Modal
	this.done = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create title
		var title = $('<span></span>').addClass('ccwpm-title-green').text(params.title);

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			self.destroy();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_export);

		// Append close button to action
		action.append(closeButton);

		// Append title to section
		header.append(title);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Download Modal
	this.download = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			self.destroy();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_export);

		// Append close button to action
		action.append(closeButton);

		// Append message to section
		section.append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Create the overlay
	this.overlay = $('<div class="ccwpm-overlay"></div>');

	// Create the modal container
	this.modal = $('<div class="ccwpm-modal-container"></div>');

	$('body').append(this.overlay) // Append overlay to body
	.append(this.modal); // Append modal to body
};

Modal.prototype.render = function (params) {

	// Show modal
	switch (params.type) {
		case 'error':
			this.error(params);
			break;

		case 'info':
			this.info(params);
			break;

		case 'done':
			this.done(params);
			break;

		case 'download':
			this.download(params);
			break;
	}
};

Modal.prototype.destroy = function () {
	this.modal.hide();
	this.overlay.hide();
};

module.exports = Modal;

/***/ })

/******/ });