/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 39);
/******/ })
/************************************************************************/
/******/ ({

/***/ 0:
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1,eval)("this");
} catch(e) {
	// This works if the window reference is available
	if(typeof window === "object")
		g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ 13:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Modal = __webpack_require__(18),
    $ = jQuery;

var Import = function Import() {
	var self = this;

	// Set params
	this.params = [];

	// Set stop flag
	this.stopImport = false;

	// Set modal
	this.modal = new Modal();

	// Set confirm listener
	this.modal.onConfirm = function (options) {
		self.onConfirm(options);
	};

	// Set blogs listener
	this.modal.onBlogs = function (options) {
		self.onBlogs(options);
	};

	// Set stop listener
	this.modal.onStop = function (options) {
		self.onStop(options);
	};
};

Import.prototype.setParams = function (params) {
	this.params = CCwpm.Util.list(params);
};

Import.prototype.start = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Set stop flag
	if (retries === 0) {
		this.stopImport = false;
	}

	// Stop running import
	if (this.stopImport) {
		return;
	}

	// Initializing beforeunload event
	$(window).bind('beforeunload', function () {
		return ccwpm_locale.stop_importing_your_website;
	});

	// Set initial status
	this.setStatus({ type: 'info', message: ccwpm_locale.preparing_to_import });

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_import.secret_key });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Import
	$.ajax({
		url: ccwpm_import.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		self.getStatus();
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_import,
				message: ccwpm_locale.unable_to_start_the_import
			});
		}

		retries++;

		setTimeout(self.start.bind(self, options, retries), timeout);
	});
};

Import.prototype.run = function (params, retries) {
	var self = this;
	var retries = retries || 0;

	// Stop running import
	if (this.stopImport) {
		return;
	}

	// Import
	$.ajax({
		url: ccwpm_import.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;

		retries++;

		setTimeout(self.run.bind(self, params, retries), timeout);
	});
};

Import.prototype.confirm = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Stop running import
	if (this.stopImport) {
		return;
	}

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_import.secret_key }).concat({ name: 'priority', value: 150 });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Confirm
	$.ajax({
		url: ccwpm_import.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		self.getStatus();
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_import,
				message: ccwpm_locale.unable_to_confirm_the_import
			});
		}

		retries++;

		setTimeout(self.confirm.bind(self, options, retries), timeout);
	});
};

Import.prototype.blogs = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Stop running import
	if (this.stopImport) {
		return;
	}

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_import.secret_key }).concat({ name: 'priority', value: 150 });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Blogs
	$.ajax({
		url: ccwpm_import.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		self.getStatus();
	}).done(function (params) {
		if (params) {
			self.run(params);
		}
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_import,
				message: ccwpm_locale.unable_to_prepare_blogs_on_import
			});
		}

		retries++;

		setTimeout(self.blogs.bind(self, options, retries), timeout);
	});
};

Import.prototype.clean = function (options, retries) {
	var self = this;
	var retries = retries || 0;

	// Set stop flag
	this.stopImport = true;

	// Set initial status
	this.setStatus({ type: 'info', message: ccwpm_locale.please_wait_stopping_the_export });

	// Set params
	var params = this.params.concat({ name: 'secret_key', value: ccwpm_import.secret_key }).concat({ name: 'priority', value: 400 });

	// Set additional params
	if (options) {
		params = params.concat(CCwpm.Util.list(options));
	}

	// Clean
	$.ajax({
		url: ccwpm_import.ajax.url,
		type: 'POST',
		dataType: 'json',
		data: params,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function () {
		// Unbinding the beforeunload event when we stop importing
		$(window).unbind('beforeunload');

		// Destroy modal
		self.modal.destroy();
	}).fail(function () {
		var timeout = retries * 1000;
		if (retries >= 5) {
			return self.setStatus({
				type: 'error',
				title: ccwpm_locale.unable_to_import,
				message: ccwpm_locale.unable_to_stop_the_import
			});
		}

		retries++;

		setTimeout(self.clean.bind(self, options, retries), timeout);
	});
};

Import.prototype.getStatus = function () {
	var self = this;

	// Stop getting status
	if (this.stopImport) {
		return;
	}

	$.ajax({
		url: ccwpm_import.status.url,
		type: 'GET',
		dataType: 'json',
		cache: false,
		dataFilter: function dataFilter(data, type) {
			return CCwpm.Util.json(data);
		}
	}).done(function (params) {
		if (params) {
			self.setStatus(params);

			// Next status
			switch (params.type) {
				case 'done':
				case 'error':
					// Unbinding the beforeunload event when any case is performed
					$(window).unbind('beforeunload');
					return;

				case 'confirm':
				case 'blogs':
					return;
			}
		}

		// Import is not done yet, let's check status in 3 seconds
		setTimeout(self.getStatus.bind(self), 3000);
	}).fail(function () {
		// Import is not done yet, let's check status in 3 seconds
		setTimeout(self.getStatus.bind(self), 3000);
	});;
};

Import.prototype.setStatus = function (params) {
	this.modal.render(params);
};

Import.prototype.onConfirm = function (options) {
	this.confirm(options);
};

Import.prototype.onBlogs = function (options) {
	this.blogs(options);
};

Import.prototype.onStop = function (options) {
	this.clean(options);
};

module.exports = Import;

/***/ }),

/***/ 18:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var $ = jQuery;

var Modal = function Modal() {
	var self = this;
	this.view = null;

	// Error Modal
	this.error = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create title
		var title = $('<span></span>').addClass('ccwpm-title-red').text(params.title);

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			self.destroy();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_import);

		// Append close button to action
		action.append(closeButton);

		// Append title to section
		header.append(title);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Progress Modal
	this.progress = function (params) {
		if (this.view === 'progress') {

			// Update progress bar meter
			this.progress.progressBarMeter.width(params.percent + '%');

			// Update progress bar percent
			this.progress.progressBarPercent.text(params.percent + '%');
		} else {

			// Create the modal container
			var container = $('<div></div>');

			// Create section to hold title, message and action
			var section = $('<section></section>');

			// Create header to hold progress bar
			var header = $('<h1></h1>');

			// Create paragraph to hold mesage
			var message = $('<p></p>');

			// Create action section
			var action = $('<div></div>');

			// Create progress bar
			var progressBar = $('<span class="ccwpm-progress-bar"></span>');

			// Create progress bar meter
			this.progress.progressBarMeter = $('<span class="ccwpm-progress-bar-meter"></span>').width(params.percent + '%');

			// Create progress bar percent
			this.progress.progressBarPercent = $('<span class="ccwpm-progress-bar-percent"></span>').text(params.percent + '%');

			// Create stop import
			var stopButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
				$(this).attr('disabled', 'disabled');
				self.onStop();
			});

			// Append text to stop button
			stopButton.append('<i class="ccwpm-icon-notification"></i> ' + ccwpm_locale.stop_import);

			// Append progress meter and progress percent
			progressBar.append(this.progress.progressBarMeter).append(this.progress.progressBarPercent);

			// Append stop button to action
			action.append(stopButton);

			// Append progress bar to section
			header.append(progressBar);

			// Append header to section
			section.append(header);

			// Append section and action to container
			container.append(section).append(action);

			// Render modal
			self.modal.html(container).show();
			self.overlay.show();
		}
	};

	// Confirm Modal
	this.confirm = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold warning
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p class="ccwpm-import-modal-content"></p>').html(params.message);

		// Create action section
		var action = $('<div class="ccwpm-import-modal-actions"></div>');

		// Create warning
		var warning = $('<i class="ccwpm-icon-notification"></i>');

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-gray"></button>').on('click', function () {
			$(this).attr('disabled', 'disabled');
			self.onStop();
		});

		// Create confirm button
		var confirmButton = $('<button type="button" class="ccwpm-button-green"></button>').on('click', function () {
			$(this).attr('disabled', 'disabled');
			self.onConfirm();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_import);

		// Append text to confirm button
		confirmButton.append(ccwpm_locale.confirm_import + ' &gt;');

		// Append close button to action
		action.append(closeButton);

		// Append confirm button to action
		action.append(confirmButton);

		// Append warning to section
		header.append(warning);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Blogs Modal
	this.blogs = function (params) {

		// Create the modal container
		var container = $('<form></form>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create title
		var title = $('<span></span>').addClass('ccwpm-title-grey').text(params.title);

		// Create continue button
		var continueButton = $('<button type="button" class="ccwpm-button-green"></button>').on('click', function () {
			$(this).attr('disabled', 'disabled');
			self.onBlogs($(this).closest('form').serializeArray());
		});

		// Append text to continue button
		continueButton.append(ccwpm_locale.continue_import);

		// Append continue button to action
		action.append(continueButton);

		// Append title to section
		header.append(title);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Info Modal
	this.info = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold loader
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create loader
		var loader = $('<span class="ccwpm-loader"></span>');

		// Create warning
		var warning = $('<p></p>').html(ccwpm_locale.please_do_not_close_this_browser);

		// Create notice to be displayed during import process
		var notice = $('<div class="ccwpm-import-modal-notice"></div>');

		// Append warning to notice
		notice.append(warning);

		// Append stop button to action
		action.append(notice);

		// Append loader to header
		header.append(loader);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Done Modal
	this.done = function (params) {

		// Create the modal container
		var container = $('<div></div>');

		// Create section to hold title, message and action
		var section = $('<section></section>');

		// Create header to hold title
		var header = $('<h1></h1>');

		// Create paragraph to hold mesage
		var message = $('<p></p>').html(params.message);

		// Create action section
		var action = $('<div></div>');

		// Create title
		var title = $('<span></span>').addClass('ccwpm-title-green').text(params.title);

		// Create close button
		var closeButton = $('<button type="button" class="ccwpm-button-red"></button>').on('click', function () {
			self.destroy();
		});

		// Append text to close button
		closeButton.append(ccwpm_locale.close_import);

		// Append close button to action
		action.append(closeButton);

		// Append title to section
		header.append(title);

		// Append header and message to section
		section.append(header).append(message);

		// Append section and action to container
		container.append(section).append(action);

		// Render modal
		self.modal.html(container).show();
		self.overlay.show();
	};

	// Create the overlay
	this.overlay = $('<div class="ccwpm-overlay"></div>');

	// Create the modal container
	this.modal = $('<div class="ccwpm-modal-container"></div>');

	$('body').append(this.overlay) // Append overlay to body
	.append(this.modal); // Append modal to body
};

Modal.prototype.render = function (params) {

	// Show modal
	switch (params.type) {
		case 'error':
			this.error(params);
			break;

		case 'confirm':
			this.confirm(params);
			break;

		case 'blogs':
			this.blogs(params);
			break;

		case 'progress':
			this.progress(params);
			break;

		case 'info':
			this.info(params);
			break;

		case 'done':
			this.done(params);
			break;
	}

	this.view = params.type;
};

Modal.prototype.destroy = function () {
	this.modal.hide();
	this.overlay.hide();
};

module.exports = Modal;

/***/ }),

/***/ 3:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function ($) {
	'use strict';

	// Review

	$('#ccwpm-feedback-type-link-1').click(function (e) {
		var radio = $('#ccwpm-feedback-type-1');
		if (radio.is(':checked')) {
			radio.attr('checked', false);
		} else {
			radio.attr('checked', true);
		}
	});

	// Idea
	$('#ccwpm-feedback-type-link-2').click(function (e) {
		var radio = $('#ccwpm-feedback-type-2');
		if (radio.is(':checked')) {
			radio.attr('checked', false);
		} else {
			radio.attr('checked', true);
		}
	});

	// Help
	$('#ccwpm-feedback-type-3').click(function () {
		// Hide other options
		$('#ccwpm-feedback-type-1, #ccwpm-feedback-type-2').closest('li').hide();

		// Change placeholder message
		$('.ccwpm-feedback-form').find('.ccwpm-feedback-message').attr('placeholder', ccwpm_locale.how_may_we_help_you);

		// Show feedback form
		$('.ccwpm-feedback-form').fadeIn();
	});

	// Cancel feedback form
	$('#ccwpm-feedback-cancel').click(function (e) {
		$('.ccwpm-feedback-form').fadeOut(function () {
			$('.ccwpm-feedback-type').attr('checked', false).closest('li').show();
		});

		e.preventDefault();
	});

	// Send feedback form
	$('#ccwpm-feedback-submit').click(function (e) {
		var self = $(this);

		var spinner = self.next();
		var type = $('.ccwpm-feedback-type:checked').val();
		var email = $('.ccwpm-feedback-email').val();
		var message = $('.ccwpm-feedback-message').val();
		var terms = $('.ccwpm-feedback-terms').is(':checked');

		self.attr('disabled', true);
		spinner.css('visibility', 'visible');

		$.ajax({
			url: ccwpm_feedback.ajax.url,
			type: 'POST',
			dataType: 'json',
			async: true,
			data: {
				'secret_key': ccwpm_feedback.secret_key,
				'ccwpm_type': type,
				'ccwpm_email': email,
				'ccwpm_message': message,
				'ccwpm_terms': +terms
			},
			dataFilter: function dataFilter(data, type) {
				return CCwpm.Util.json(data);
			}
		}).done(function (data) {
			self.attr('disabled', false);
			spinner.css('visibility', 'hidden');

			if (data.errors.length > 0) {
				$('.ccwpm-feedback .ccwpm-message').remove();

				var errorMessage = $('<div />').addClass('ccwpm-message ccwpm-error-message');
				$.each(data.errors, function (key, value) {
					errorMessage.append($('<p />').text(value));
				});

				$('.ccwpm-feedback').prepend(errorMessage);
			} else {
				var successMessage = $('<div />').addClass('ccwpm-message ccwpm-success-message');
				successMessage.append($('<p />').text(ccwpm_locale.thanks_for_submitting_your_feedback));

				$('.ccwpm-feedback').html(successMessage);
			}
		});

		e.preventDefault();
	});
});

/***/ }),

/***/ 39:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

var Feedback = __webpack_require__(3),
    Report = __webpack_require__(4),
    Import = __webpack_require__(13);

jQuery(document).ready(function ($) {
	'use strict';

	$('.ccwpm-backup-actions > a').hover(function () {
		$(this).addClass('ccwpm-button-on');
	}, function () {
		$(this).removeClass('ccwpm-button-on');
	});

	// Delete file
	$('.ccwpm-backup-delete').click(function (e) {
		var self = $(this);

		// Delete file
		if (confirm(ccwpm_locale.want_to_delete_this_file)) {
			$.ajax({
				url: ccwpm_backups.ajax.url,
				type: 'POST',
				dataType: 'json',
				data: {
					'secret_key': ccwpm_backups.secret_key,
					'archive': self.data('archive')
				},
				dataFilter: function dataFilter(data, type) {
					return CCwpm.Util.json(data);
				}
			}).done(function (data) {
				if (data.errors.length === 0) {
					self.closest('tr').remove();
					if ($('.ccwpm-backups tbody tr').length === 0) {
						$('.ccwpm-backups').addClass('ccwpm-hide');
						$('.ccwpm-backups-empty').removeClass('ccwpm-hide');
					}
				}
			});
		}

		e.preventDefault();
	});

	var model = new Import();

	// Restore from file
	$('.ccwpm-backup-restore').click(function (e) {
		var storage = CCwpm.Util.random(12);
		var options = CCwpm.Util.form('#ccwpm-backups-form').concat({ name: 'storage', value: storage }).concat({ name: 'archive', value: $(this).data('archive') });

		// Set global params
		model.setParams(options);

		// Start import
		model.start();

		e.preventDefault();
	});
});

global.CCwpm = jQuery.extend({}, global.CCwpm, { Feedback: Feedback, Report: Report, Import: Import });
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(0)))

/***/ }),

/***/ 4:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

jQuery(document).ready(function ($) {
	'use strict';

	$('#ccwpm-report-problem-button').click(function (e) {
		$(this).next('.ccwpm-report-problem-dialog').toggleClass('ccwpm-report-active');

		e.preventDefault();
	});

	$('#ccwpm-report-cancel').click(function (e) {
		$(this).closest('.ccwpm-report-problem-dialog').removeClass('ccwpm-report-active');

		e.preventDefault();
	});

	$('#ccwpm-report-submit').click(function (r) {
		var self = $(this);

		var spinner = self.next();
		var email = $('.ccwpm-report-email').val();
		var message = $('.ccwpm-report-message').val();
		var terms = $('.ccwpm-report-terms').is(':checked');

		self.attr('disabled', true);
		spinner.css('visibility', 'visible');

		$.ajax({
			url: ccwpm_report.ajax.url,
			type: 'POST',
			dataType: 'json',
			async: true,
			data: {
				'secret_key': ccwpm_report.secret_key,
				'ccwpm_email': email,
				'ccwpm_message': message,
				'ccwpm_terms': +terms
			},
			dataFilter: function dataFilter(data, type) {
				return CCwpm.Util.json(data);
			}
		}).done(function (data) {
			self.attr('disabled', false);
			spinner.css('visibility', 'hidden');

			if (data.errors.length > 0) {
				$('.ccwpm-report-problem-dialog .ccwpm-message').remove();

				var errorMessage = $('<div />').addClass('ccwpm-message ccwpm-error-message');
				$.each(data.errors, function (key, value) {
					errorMessage.append($('<p />').text(value));
				});

				$('.ccwpm-report-problem-dialog').prepend(errorMessage);
			} else {
				var successMessage = $('<div />').addClass('ccwpm-message ccwpm-success-message');
				successMessage.append($('<p />').text(ccwpm_locale.thanks_for_submitting_your_request));

				$('.ccwpm-report-problem-dialog').html(successMessage);

				// Hide message
				setTimeout(function () {
					$('.ccwpm-report-problem-dialog').removeClass('ccwpm-report-active');
				}, 2000);
			}
		});

		e.preventDefault();
	});
});

/***/ })

/******/ });