<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

class CCwpm_Import_Enumerate {

	public static function execute( $params ) {

		// Set progress
		CCwpm_Status::info( __( 'Retrieving a list of all WordPress files...', CCWPM_PLUGIN_NAME ) );

		// Open the archive file for reading
		$archive = new CCwpm_Extractor( ccwpm_archive_path( $params ) );

		// Get total files count
		$params['total_files_count'] = $archive->get_total_files_count();

		// Get total files size
		$params['total_files_size'] = $archive->get_total_files_size();

		// Close the archive file
		$archive->close();

		// Set progress
		CCwpm_Status::info( __( 'Done retrieving a list of all WordPress files.', CCWPM_PLUGIN_NAME ) );

		return $params;
	}
}
