<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

class CCwpm_Import_Done {

	public static function execute( $params ) {

		// Check multisite.json file
		if ( true === is_file( ccwpm_multisite_path( $params ) ) ) {
			// Read multisite.json file
			$handle = ccwpm_open( ccwpm_multisite_path( $params ), 'r' );

			// Parse multisite.json file
			$multisite = ccwpm_read( $handle, filesize( ccwpm_multisite_path( $params ) ) );
			$multisite = json_decode( $multisite, true );

			// Close handle
			ccwpm_close( $handle );

			// Activate WordPress plugins
			if ( isset( $multisite['Plugins'] ) && ( $plugins = $multisite['Plugins'] ) ) {
				ccwpm_activate_plugins( $plugins );
			}

			// Deactivate WordPress SSL plugins
			if ( ! is_ssl() ) {
				ccwpm_deactivate_plugins( array(
					ccwpm_discover_plugin_basename( 'really-simple-ssl/rlrsssl-really-simple-ssl.php' ),
					ccwpm_discover_plugin_basename( 'wordpress-https/wordpress-https.php' ),
					ccwpm_discover_plugin_basename( 'wp-force-ssl/wp-force-ssl.php' ),
				) );
			}

			// Deactivate WordPress plugins
			ccwpm_deactivate_plugins( array(
				ccwpm_discover_plugin_basename( 'invisible-recaptcha/invisible-recaptcha.php' ),
				ccwpm_discover_plugin_basename( 'wps-hide-login/wps-hide-login.php' ),
				ccwpm_discover_plugin_basename( 'hide-my-wp/index.php' ),
				ccwpm_discover_plugin_basename( 'hide-my-wordpress/index.php' ),
				ccwpm_discover_plugin_basename( 'mycustomwidget/my_custom_widget.php' ),
				ccwpm_discover_plugin_basename( 'lockdown-wp-admin/lockdown-wp-admin.php' ),
				ccwpm_discover_plugin_basename( 'rename-wp-login/rename-wp-login.php' ),
			) );

			// Deactivate Jetpack modules
			ccwpm_deactivate_jetpack_modules( array(
				'photon',
				'sso',
			) );

		} else {

			// Check package.json file
			if ( true === is_file( ccwpm_package_path( $params ) ) ) {

				// Read package.json file
				$handle = ccwpm_open( ccwpm_package_path( $params ), 'r' );

				// Parse package.json file
				$package = ccwpm_read( $handle, filesize( ccwpm_package_path( $params ) ) );
				$package = json_decode( $package, true );

				// Close handle
				ccwpm_close( $handle );

				// Activate WordPress plugins
				if ( isset( $package['Plugins'] ) && ( $plugins = $package['Plugins'] ) ) {
					ccwpm_activate_plugins( $plugins );
				}

				// Activate WordPress template
				if ( isset( $package['Template'] ) && ( $template = $package['Template'] ) ) {
					ccwpm_activate_template( $template );
				}

				// Activate WordPress stylesheet
				if ( isset( $package['Stylesheet'] ) && ( $stylesheet = $package['Stylesheet'] ) ) {
					ccwpm_activate_stylesheet( $stylesheet );
				}

				// Deactivate WordPress SSL plugins
				if ( ! is_ssl() ) {
					ccwpm_deactivate_plugins( array(
						ccwpm_discover_plugin_basename( 'really-simple-ssl/rlrsssl-really-simple-ssl.php' ),
						ccwpm_discover_plugin_basename( 'wordpress-https/wordpress-https.php' ),
						ccwpm_discover_plugin_basename( 'wp-force-ssl/wp-force-ssl.php' ),
					) );
				}

				// Deactivate WordPress plugins
				ccwpm_deactivate_plugins( array(
					ccwpm_discover_plugin_basename( 'invisible-recaptcha/invisible-recaptcha.php' ),
					ccwpm_discover_plugin_basename( 'wps-hide-login/wps-hide-login.php' ),
					ccwpm_discover_plugin_basename( 'hide-my-wp/index.php' ),
					ccwpm_discover_plugin_basename( 'hide-my-wordpress/index.php' ),
					ccwpm_discover_plugin_basename( 'mycustomwidget/my_custom_widget.php' ),
					ccwpm_discover_plugin_basename( 'lockdown-wp-admin/lockdown-wp-admin.php' ),
					ccwpm_discover_plugin_basename( 'rename-wp-login/rename-wp-login.php' ),
				) );

				// Deactivate Jetpack modules
				ccwpm_deactivate_jetpack_modules( array(
					'photon',
					'sso',
				) );
			}
		}

		// Check blogs.json file
		if ( true === is_file( ccwpm_blogs_path( $params ) ) ) {
			// Read blogs.json file
			$handle = ccwpm_open( ccwpm_blogs_path( $params ), 'r' );

			// Parse blogs.json file
			$blogs = ccwpm_read( $handle, filesize( ccwpm_blogs_path( $params ) ) );
			$blogs = json_decode( $blogs, true );

			// Close handle
			ccwpm_close( $handle );

			// Loop over blogs
			foreach ( $blogs as $blog ) {

				// Activate WordPress plugins
				if ( isset( $blog['New']['Plugins'] ) && ( $plugins = $blog['New']['Plugins'] ) ) {
					ccwpm_activate_plugins( $plugins );
				}

				// Activate WordPress template
				if ( isset( $blog['New']['Template'] ) && ( $template = $blog['New']['Template'] ) ) {
					ccwpm_activate_template( $template );
				}

				// Activate WordPress stylesheet
				if ( isset( $blog['New']['Stylesheet'] ) && ( $stylesheet = $blog['New']['Stylesheet'] ) ) {
					ccwpm_activate_stylesheet( $stylesheet );
				}

				// Deactivate WordPress SSL plugins
				if ( ! is_ssl() ) {
					ccwpm_deactivate_plugins( array(
						ccwpm_discover_plugin_basename( 'really-simple-ssl/rlrsssl-really-simple-ssl.php' ),
						ccwpm_discover_plugin_basename( 'wordpress-https/wordpress-https.php' ),
						ccwpm_discover_plugin_basename( 'wp-force-ssl/wp-force-ssl.php' ),
					) );
				}

				// Deactivate WordPress plugins
				ccwpm_deactivate_plugins( array(
					ccwpm_discover_plugin_basename( 'invisible-recaptcha/invisible-recaptcha.php' ),
					ccwpm_discover_plugin_basename( 'wps-hide-login/wps-hide-login.php' ),
					ccwpm_discover_plugin_basename( 'hide-my-wp/index.php' ),
					ccwpm_discover_plugin_basename( 'hide-my-wordpress/index.php' ),
					ccwpm_discover_plugin_basename( 'mycustomwidget/my_custom_widget.php' ),
					ccwpm_discover_plugin_basename( 'lockdown-wp-admin/lockdown-wp-admin.php' ),
					ccwpm_discover_plugin_basename( 'rename-wp-login/rename-wp-login.php' ),
				) );

				// Deactivate Jetpack modules
				ccwpm_deactivate_jetpack_modules( array(
					'photon',
					'sso',
				) );
			}
		}

		// Set progress
		CCwpm_Status::done(
			__(
				'Your data has been imported successfully!',
				CCWPM_PLUGIN_NAME
			),
			sprintf(
				__(
					'You need to perform two more steps:<br />' .
					'<strong>1. You must save your permalinks structure twice. <a class="ccwpm-no-underline" href="%s" target="_blank">Permalinks Settings</a></strong> <small>(opens a new window)</small><br />' .
					'<strong>2. <a class="ccwpm-no-underline" href="https://wordpress.org/support/view/plugin-reviews/cc-wp-migration?rate=5#postform" target="_blank">Optionally, review the plugin</a>.</strong> <small>(opens a new window)</small>',
					CCWPM_PLUGIN_NAME
				),
				admin_url( 'options-permalink.php#submit' )
			)
		);

		return $params;
	}
}
