<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

class CCwpm_Import_Confirm {

	public static function execute( $params ) {

		$messages = array();

		// Read package.json file
		$handle = ccwpm_open( ccwpm_package_path( $params ), 'r' );

		// Parse package.json file
		$package = ccwpm_read( $handle, filesize( ccwpm_package_path( $params ) ) );
		$package = json_decode( $package, true );

		// Close handle
		ccwpm_close( $handle );

		// Set message
		$messages[] = __(
			'The import process will overwrite your website including the database, media, plugins, and themes. ' .
			'Please ensure that you have a backup of your data before proceeding to the next step.',
			CCWPM_PLUGIN_NAME
		);

		// Check compatibility of PHP versions
		if ( isset( $package['PHP']['Version'] ) ) {
			if ( version_compare( $package['PHP']['Version'], '7.0.0', '<' ) && version_compare( PHP_VERSION, '7.0.0', '>=' ) ) {
				$messages[] = __(
					'<i class="ccwpm-import-info">Your backup is from a PHP 5 but the site that you are importing to is PHP 7. ' .
					'This could cause the import to fail. <a href="https://help.ccwpmigration.xyz/knowledgebase/migrate-wordpress-from-php-5-to-php-7/" target="_blank">Technical details</a></i>',
					CCWPM_PLUGIN_NAME
				);
			}
		}

		// Set progress
		CCwpm_Status::confirm( implode( $messages ) );
		exit;
	}
}
