<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

class CCwpm_Extensions {

	/**
	 * Get active extensions
	 *
	 * @return array
	 */
	public static function get() {
		$extensions = array();

		// Add Microsoft Azure extension
		if ( defined( 'CCWPMZE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMZE_PLUGIN_NAME ] = array(
				'key'      => CCWPMZE_PLUGIN_KEY,
				'title'    => CCWPMZE_PLUGIN_TITLE,
				'about'    => CCWPMZE_PLUGIN_ABOUT,
				'basename' => CCWPMZE_PLUGIN_BASENAME,
				'version'  => CCWPMZE_VERSION,
				'requires' => '1.1',
				'short'    => CCWPMZE_PLUGIN_SHORT,
			);
		}

		// Add Backblaze B2 extension
		if ( defined( 'CCWPMAE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMAE_PLUGIN_NAME ] = array(
				'key'      => CCWPMAE_PLUGIN_KEY,
				'title'    => CCWPMAE_PLUGIN_TITLE,
				'about'    => CCWPMAE_PLUGIN_ABOUT,
				'basename' => CCWPMAE_PLUGIN_BASENAME,
				'version'  => CCWPMAE_VERSION,
				'requires' => '1.3',
				'short'    => CCWPMAE_PLUGIN_SHORT,
			);
		}

		// Add Box Extension
		if ( defined( 'CCWPMBE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMBE_PLUGIN_NAME ] = array(
				'key'      => CCWPMBE_PLUGIN_KEY,
				'title'    => CCWPMBE_PLUGIN_TITLE,
				'about'    => CCWPMBE_PLUGIN_ABOUT,
				'basename' => CCWPMBE_PLUGIN_BASENAME,
				'version'  => CCWPMBE_VERSION,
				'requires' => '1.13',
				'short'    => CCWPMBE_PLUGIN_SHORT,
			);
		}

		// Add DigitalOcean Extension
		if ( defined( 'CCWPMIE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMIE_PLUGIN_NAME ] = array(
				'key'      => CCWPMIE_PLUGIN_KEY,
				'title'    => CCWPMIE_PLUGIN_TITLE,
				'about'    => CCWPMIE_PLUGIN_ABOUT,
				'basename' => CCWPMIE_PLUGIN_BASENAME,
				'version'  => CCWPMIE_VERSION,
				'requires' => '1.6',
				'short'    => CCWPMIE_PLUGIN_SHORT,
			);
		}

		// Add Dropbox Extension
		if ( defined( 'CCWPMDE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMDE_PLUGIN_NAME ] = array(
				'key'      => CCWPMDE_PLUGIN_KEY,
				'title'    => CCWPMDE_PLUGIN_TITLE,
				'about'    => CCWPMDE_PLUGIN_ABOUT,
				'basename' => CCWPMDE_PLUGIN_BASENAME,
				'version'  => CCWPMDE_VERSION,
				'requires' => '3.32',
				'short'    => CCWPMDE_PLUGIN_SHORT,
			);
		}

		// Add FTP Extension
		if ( defined( 'CCWPMFE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMFE_PLUGIN_NAME ] = array(
				'key'      => CCWPMFE_PLUGIN_KEY,
				'title'    => CCWPMFE_PLUGIN_TITLE,
				'about'    => CCWPMFE_PLUGIN_ABOUT,
				'basename' => CCWPMFE_PLUGIN_BASENAME,
				'version'  => CCWPMFE_VERSION,
				'requires' => '2.37',
				'short'    => CCWPMFE_PLUGIN_SHORT,
			);
		}

		// Add Google Cloud Storage Extension
		if ( defined( 'CCWPMCE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMCE_PLUGIN_NAME ] = array(
				'key'      => CCWPMCE_PLUGIN_KEY,
				'title'    => CCWPMCE_PLUGIN_TITLE,
				'about'    => CCWPMCE_PLUGIN_ABOUT,
				'basename' => CCWPMCE_PLUGIN_BASENAME,
				'version'  => CCWPMCE_VERSION,
				'requires' => '1.0',
				'short'    => CCWPMCE_PLUGIN_SHORT,
			);
		}

		// Add Google Drive Extension
		if ( defined( 'CCWPMGE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMGE_PLUGIN_NAME ] = array(
				'key'      => CCWPMGE_PLUGIN_KEY,
				'title'    => CCWPMGE_PLUGIN_TITLE,
				'about'    => CCWPMGE_PLUGIN_ABOUT,
				'basename' => CCWPMGE_PLUGIN_BASENAME,
				'version'  => CCWPMGE_VERSION,
				'requires' => '2.36',
				'short'    => CCWPMGE_PLUGIN_SHORT,
			);
		}

		// Add Amazon Glacier extension
		if ( defined( 'CCWPMRE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMRE_PLUGIN_NAME ] = array(
				'key'      => CCWPMRE_PLUGIN_KEY,
				'title'    => CCWPMRE_PLUGIN_TITLE,
				'about'    => CCWPMRE_PLUGIN_ABOUT,
				'basename' => CCWPMRE_PLUGIN_BASENAME,
				'version'  => CCWPMRE_VERSION,
				'requires' => '1.0',
				'short'    => CCWPMRE_PLUGIN_SHORT,
			);
		}

		// Add Mega Extension
		if ( defined( 'CCWPMEE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMEE_PLUGIN_NAME ] = array(
				'key'      => CCWPMEE_PLUGIN_KEY,
				'title'    => CCWPMEE_PLUGIN_TITLE,
				'about'    => CCWPMEE_PLUGIN_ABOUT,
				'basename' => CCWPMEE_PLUGIN_BASENAME,
				'version'  => CCWPMEE_VERSION,
				'requires' => '1.10',
				'short'    => CCWPMEE_PLUGIN_SHORT,
			);
		}

		// Add Multisite Extension
		if ( defined( 'CCWPMME_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMME_PLUGIN_NAME ] = array(
				'key'      => CCWPMME_PLUGIN_KEY,
				'title'    => CCWPMME_PLUGIN_TITLE,
				'about'    => CCWPMME_PLUGIN_ABOUT,
				'basename' => CCWPMME_PLUGIN_BASENAME,
				'version'  => CCWPMME_VERSION,
				'requires' => '3.59',
				'short'    => CCWPMME_PLUGIN_SHORT,
			);
		}

		// Add OneDrive Extension
		if ( defined( 'CCWPMOE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMOE_PLUGIN_NAME ] = array(
				'key'      => CCWPMOE_PLUGIN_KEY,
				'title'    => CCWPMOE_PLUGIN_TITLE,
				'about'    => CCWPMOE_PLUGIN_ABOUT,
				'basename' => CCWPMOE_PLUGIN_BASENAME,
				'version'  => CCWPMOE_VERSION,
				'requires' => '1.23',
				'short'    => CCWPMOE_PLUGIN_SHORT,
			);
		}

		// Add pCloud Extension
		if ( defined( 'CCWPMPE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMPE_PLUGIN_NAME ] = array(
				'key'      => CCWPMPE_PLUGIN_KEY,
				'title'    => CCWPMPE_PLUGIN_TITLE,
				'about'    => CCWPMPE_PLUGIN_ABOUT,
				'basename' => CCWPMPE_PLUGIN_BASENAME,
				'version'  => CCWPMPE_VERSION,
				'requires' => '1.0',
				'short'    => CCWPMPE_PLUGIN_SHORT,
			);
		}

		// Add Amazon S3 extension
		if ( defined( 'CCWPMSE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMSE_PLUGIN_NAME ] = array(
				'key'      => CCWPMSE_PLUGIN_KEY,
				'title'    => CCWPMSE_PLUGIN_TITLE,
				'about'    => CCWPMSE_PLUGIN_ABOUT,
				'basename' => CCWPMSE_PLUGIN_BASENAME,
				'version'  => CCWPMSE_VERSION,
				'requires' => '3.27',
				'short'    => CCWPMSE_PLUGIN_SHORT,
			);
		}

		// Add Unlimited Extension
		if ( defined( 'CCWPMUE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMUE_PLUGIN_NAME ] = array(
				'key'      => CCWPMUE_PLUGIN_KEY,
				'title'    => CCWPMUE_PLUGIN_TITLE,
				'about'    => CCWPMUE_PLUGIN_ABOUT,
				'basename' => CCWPMUE_PLUGIN_BASENAME,
				'version'  => CCWPMUE_VERSION,
				'requires' => '2.18',
				'short'    => CCWPMUE_PLUGIN_SHORT,
			);
		}

		// Add URL Extension
		if ( defined( 'CCWPMLE_PLUGIN_NAME' ) ) {
			$extensions[ CCWPMLE_PLUGIN_NAME ] = array(
				'key'      => CCWPMLE_PLUGIN_KEY,
				'title'    => CCWPMLE_PLUGIN_TITLE,
				'about'    => CCWPMLE_PLUGIN_ABOUT,
				'basename' => CCWPMLE_PLUGIN_BASENAME,
				'version'  => CCWPMLE_VERSION,
				'requires' => '2.27',
				'short'    => CCWPMLE_PLUGIN_SHORT,
			);
		}

		return $extensions;
	}
}
