<?php
/**
 * Copyright (C) 2022 Stephen A.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// ================
// = Plugin Debug =
// ================
define( 'CCWPM_DEBUG', false );

// ==================
// = Plugin Version =
// ==================
define( 'CCWPM_VERSION', '0.001' );

// ===============
// = Plugin Name =
// ===============
define( 'CCWPM_PLUGIN_NAME', 'cc-wp-migration' );

// ============================
// = Directory index.php File =
// ============================
define( 'CCWPM_DIRECTORY_INDEX', 'index.php' );

// ================
// = Storage Path =
// ================
define( 'CCWPM_STORAGE_PATH', CCWPM_PATH . DIRECTORY_SEPARATOR . 'storage' );

// ==================
// = Error Log Path =
// ==================
define( 'CCWPM_ERROR_FILE', CCWPM_STORAGE_PATH . DIRECTORY_SEPARATOR . 'error.log' );

// ===============
// = Status Path =
// ===============
define( 'CCWPM_STATUS_FILE', CCWPM_STORAGE_PATH . DIRECTORY_SEPARATOR . 'status.js' );

// ============
// = Lib Path =
// ============
define( 'CCWPM_LIB_PATH', CCWPM_PATH . DIRECTORY_SEPARATOR . 'lib' );

// ===================
// = Controller Path =
// ===================
define( 'CCWPM_CONTROLLER_PATH', CCWPM_LIB_PATH . DIRECTORY_SEPARATOR . 'controller' );

// ==============
// = Model Path =
// ==============
define( 'CCWPM_MODEL_PATH', CCWPM_LIB_PATH . DIRECTORY_SEPARATOR . 'model' );

// ===============
// = Export Path =
// ===============
define( 'CCWPM_EXPORT_PATH', CCWPM_MODEL_PATH . DIRECTORY_SEPARATOR . 'export' );

// ===============
// = Import Path =
// ===============
define( 'CCWPM_IMPORT_PATH', CCWPM_MODEL_PATH . DIRECTORY_SEPARATOR . 'import' );

// =============
// = View Path =
// =============
define( 'CCWPM_TEMPLATES_PATH', CCWPM_LIB_PATH . DIRECTORY_SEPARATOR . 'view' );

// ===================
// = Set Ccwpandar Path =
// ===================
define( 'CCWPANDAR_TEMPLATES_PATH', CCWPM_TEMPLATES_PATH );

// ===============
// = Vendor Path =
// ===============
define( 'CCWPM_VENDOR_PATH', CCWPM_LIB_PATH . DIRECTORY_SEPARATOR . 'vendor' );

// =========================
// = CCWPMask Feedback Url =
// =========================
define( 'CCWPM_FEEDBACK_URL', 'https://ccwpmigration.xyz/ccwpm/feedback/create' );

// =======================
// = CCWPMask Report Url =
// =======================
define( 'CCWPM_REPORT_URL', 'https://ccwpmigration.xyz/ccwpm/report/create' );

// ==============================
// = CCWPMask Archive Tools Url =
// ==============================
define( 'CCWPM_ARCHIVE_TOOLS_URL', 'https://ccwpmigration.xyz/archive/tools' );

// =========================
// = CCWPMask Table Prefix =
// =========================
define( 'CCWPM_TABLE_PREFIX', 'CCWPMASK_PREFIX_' );

// ========================
// = Archive Backups Name =
// ========================
define( 'CCWPM_BACKUPS_NAME', 'ccwpm-backups' );

// =========================
// = Archive Database Name =
// =========================
define( 'CCWPM_DATABASE_NAME', 'database.sql' );

// ========================
// = Archive Package Name =
// ========================
define( 'CCWPM_PACKAGE_NAME', 'package.json' );

// ==========================
// = Archive Multisite Name =
// ==========================
define( 'CCWPM_MULTISITE_NAME', 'multisite.json' );

// ======================
// = Archive Blogs Name =
// ======================
define( 'CCWPM_BLOGS_NAME', 'blogs.json' );

// =========================
// = Archive Settings Name =
// =========================
define( 'CCWPM_SETTINGS_NAME', 'settings.json' );

// ==========================
// = Archive Multipart Name =
// ==========================
define( 'CCWPM_MULTIPART_NAME', 'multipart.list' );

// ========================
// = Archive Filemap Name =
// ========================
define( 'CCWPM_FILEMAP_NAME', 'filemap.list' );

// =================================
// = Archive Must-Use Plugins Name =
// =================================
define( 'CCWPM_MUPLUGINS_NAME', 'mu-plugins' );

// =============================
// = Endurance Page Cache Name =
// =============================
define( 'CCWPM_ENDURANCE_PAGE_CACHE_NAME', 'endurance-page-cache.php' );

// ===========================
// = Endurance PHP Edge Name =
// ===========================
define( 'CCWPM_ENDURANCE_PHP_EDGE_NAME', 'endurance-php-edge.php' );

// ================================
// = Endurance Browser Cache Name =
// ================================
define( 'CCWPM_ENDURANCE_BROWSER_CACHE_NAME', 'endurance-browser-cache.php' );

// =========================
// = GD System Plugin Name =
// =========================
define( 'CCWPM_GD_SYSTEM_PLUGIN_NAME', 'gd-system-plugin.php' );

// ===================
// = Export Log Name =
// ===================
define( 'CCWPM_EXPORT_NAME', 'export.log' );

// ===================
// = Import Log Name =
// ===================
define( 'CCWPM_IMPORT_NAME', 'import.log' );

// ==================
// = Error Log Name =
// ==================
define( 'CCWPM_ERROR_NAME', 'error.log' );

// ==============
// = Secret Key =
// ==============
define( 'CCWPM_SECRET_KEY', 'ccwpm_secret_key' );

// =============
// = Auth User =
// =============
define( 'CCWPM_AUTH_USER', 'ccwpm_auth_user' );

// =================
// = Auth Password =
// =================
define( 'CCWPM_AUTH_PASSWORD', 'ccwpm_auth_password' );

// ============
// = Site URL =
// ============
define( 'CCWPM_SITE_URL', 'siteurl' );

// ============
// = Home URL =
// ============
define( 'CCWPM_HOME_URL', 'home' );

// ==================
// = Active Plugins =
// ==================
define( 'CCWPM_ACTIVE_PLUGINS', 'active_plugins' );

// ===========================
// = Active Sitewide Plugins =
// ===========================
define( 'CCWPM_ACTIVE_SITEWIDE_PLUGINS', 'active_sitewide_plugins' );

// ==========================
// = Jetpack Active Modules =
// ==========================
define( 'CCWPM_JETPACK_ACTIVE_MODULES', 'jetpack_active_modules' );

// ======================
// = MS Files Rewriting =
// ======================
define( 'CCWPM_MS_FILES_REWRITING', 'ms_files_rewriting' );

// ===================
// = Active Template =
// ===================
define( 'CCWPM_ACTIVE_TEMPLATE', 'template' );

// =====================
// = Active Stylesheet =
// =====================
define( 'CCWPM_ACTIVE_STYLESHEET', 'stylesheet' );

// ============
// = Cron Key =
// ============
define( 'CCWPM_CRON', 'cron' );

// ===============
// = Updater Key =
// ===============
define( 'CCWPM_UPDATER', 'ccwpm_updater' );

// ==============
// = Status Key =
// ==============
define( 'CCWPM_STATUS', 'ccwpm_status' );

// ================
// = Messages Key =
// ================
define( 'CCWPM_MESSAGES', 'ccwpm_messages' );

// =================
// = Support Email =
// =================
define( 'CCWPM_SUPPORT_EMAIL', 'support@ccwpmigration.xyz' );

// =================
// = Max File Size =
// =================
define( 'CCWPM_MAX_FILE_SIZE', 5368709120 * 20 );

// ==================
// = Max Chunk Size =
// ==================
define( 'CCWPM_MAX_CHUNK_SIZE', 5 * 1024 * 1024 );

// =====================
// = Max Chunk Retries =
// =====================
define( 'CCWPM_MAX_CHUNK_RETRIES', 10 );

// ===========================
// = WP_CONTENT_DIR Constant =
// ===========================
if ( ! defined( 'WP_CONTENT_DIR' ) ) {
	define( 'WP_CONTENT_DIR', ABSPATH . 'wp-content' );
}

// ================
// = Uploads Path =
// ================
define( 'CCWPM_UPLOADS_PATH', 'uploads' );

// ==============
// = Blogs Path =
// ==============
define( 'CCWPM_BLOGSDIR_PATH', 'blogs.dir' );

// ==============
// = Sites Path =
// ==============
define( 'CCWPM_SITES_PATH', CCWPM_UPLOADS_PATH . DIRECTORY_SEPARATOR . 'sites' );

// ================
// = Backups Path =
// ================
define( 'CCWPM_BACKUPS_PATH', WP_CONTENT_DIR . DIRECTORY_SEPARATOR . 'ccwpm-backups' );

// ==========================
// = Storage index.php File =
// ==========================
define( 'CCWPM_STORAGE_INDEX', CCWPM_STORAGE_PATH . DIRECTORY_SEPARATOR . 'index.php' );

// ==========================
// = Backups index.php File =
// ==========================
define( 'CCWPM_BACKUPS_INDEX', CCWPM_BACKUPS_PATH . DIRECTORY_SEPARATOR . 'index.php' );

// ==========================
// = Backups .htaccess File =
// ==========================
define( 'CCWPM_BACKUPS_HTACCESS', CCWPM_BACKUPS_PATH . DIRECTORY_SEPARATOR . '.htaccess' );

// ===========================
// = Backups web.config File =
// ===========================
define( 'CCWPM_BACKUPS_WEBCONFIG', CCWPM_BACKUPS_PATH . DIRECTORY_SEPARATOR . 'web.config' );

// ============================
// = WordPress .htaccess File =
// ============================
define( 'CCWPM_WORDPRESS_HTACCESS', ABSPATH . DIRECTORY_SEPARATOR . '.htaccess' );

// ================================
// = WP Migration Plugin Base Dir =
// ================================
if ( defined( 'CCWPM_PLUGIN_BASENAME' ) ) {
	define( 'CCWPM_PLUGIN_BASEDIR', dirname( CCWPM_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPM_PLUGIN_BASEDIR', 'cc-wp-migration' );
}

// ======================================
// = Microsoft Azure Extension Base Dir =
// ======================================
if ( defined( 'CCWPMZE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMZE_PLUGIN_BASEDIR', dirname( CCWPMZE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMZE_PLUGIN_BASEDIR', 'cc-wp-migration-azure-storage-extension' );
}

// ===================================
// = Microsoft Azure Extension Title =
// ===================================
if ( ! defined( 'CCWPMZE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMZE_PLUGIN_TITLE', 'Microsoft Azure Storage Extension' );
}

// ===================================
// = Microsoft Azure Extension About =
// ===================================
if ( ! defined( 'CCWPMZE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMZE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/microsoft-azure-storage-extension/about' );
}

// =================================
// = Microsoft Azure Extension Key =
// =================================
if ( ! defined( 'CCWPMZE_PLUGIN_KEY' ) ) {
	define( 'CCWPMZE_PLUGIN_KEY', 'ccwpmze_plugin_key' );
}

// ===================================
// = Microsoft Azure Extension Short =
// ===================================
if ( ! defined( 'CCWPMZE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMZE_PLUGIN_SHORT', 'azure-storage' );
}

// ===================================
// = Backblaze B2 Extension Base Dir =
// ===================================
if ( defined( 'CCWPMAE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMAE_PLUGIN_BASEDIR', dirname( CCWPMAE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMAE_PLUGIN_BASEDIR', 'cc-wp-migration-b2-extension' );
}

// ================================
// = Backblaze B2 Extension Title =
// ================================
if ( ! defined( 'CCWPMAE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMAE_PLUGIN_TITLE', 'Backblaze B2 Extension' );
}

// ================================
// = Backblaze B2 Extension About =
// ================================
if ( ! defined( 'CCWPMAE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMAE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/backblaze-b2-extension/about' );
}

// ==============================
// = Backblaze B2 Extension Key =
// ==============================
if ( ! defined( 'CCWPMAE_PLUGIN_KEY' ) ) {
	define( 'CCWPMAE_PLUGIN_KEY', 'ccwpmae_plugin_key' );
}

// ================================
// = Backblaze B2 Extension Short =
// ================================
if ( ! defined( 'CCWPMAE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMAE_PLUGIN_SHORT', 'b2' );
}

// ==========================
// = Box Extension Base Dir =
// ==========================
if ( defined( 'CCWPMBE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMBE_PLUGIN_BASEDIR', dirname( CCWPMBE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMBE_PLUGIN_BASEDIR', 'cc-wp-migration-box-extension' );
}

// =======================
// = Box Extension Title =
// =======================
if ( ! defined( 'CCWPMBE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMBE_PLUGIN_TITLE', 'Box Extension' );
}

// =======================
// = Box Extension About =
// =======================
if ( ! defined( 'CCWPMBE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMBE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/box-extension/about' );
}

// =====================
// = Box Extension Key =
// =====================
if ( ! defined( 'CCWPMBE_PLUGIN_KEY' ) ) {
	define( 'CCWPMBE_PLUGIN_KEY', 'ccwpmbe_plugin_key' );
}

// =======================
// = Box Extension Short =
// =======================
if ( ! defined( 'CCWPMBE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMBE_PLUGIN_SHORT', 'box' );
}

// ===================================
// = DigitalOcean Extension Base Dir =
// ===================================
if ( defined( 'CCWPMIE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMIE_PLUGIN_BASEDIR', dirname( CCWPMIE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMIE_PLUGIN_BASEDIR', 'cc-wp-migration-digitalocean-extension' );
}

// ================================
// = DigitalOcean Extension Title =
// ================================
if ( ! defined( 'CCWPMIE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMIE_PLUGIN_TITLE', 'DigitalOcean Spaces Extension' );
}

// ================================
// = DigitalOcean Extension About =
// ================================
if ( ! defined( 'CCWPMIE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMIE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/digitalocean-spaces-extension/about' );
}

// ==============================
// = DigitalOcean Extension Key =
// ==============================
if ( ! defined( 'CCWPMIE_PLUGIN_KEY' ) ) {
	define( 'CCWPMIE_PLUGIN_KEY', 'ccwpmie_plugin_key' );
}

// ================================
// = DigitalOcean Extension Short =
// ================================
if ( ! defined( 'CCWPMIE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMIE_PLUGIN_SHORT', 'digitalocean' );
}

// ==============================
// = Dropbox Extension Base Dir =
// ==============================
if ( defined( 'CCWPMDE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMDE_PLUGIN_BASEDIR', dirname( CCWPMDE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMDE_PLUGIN_BASEDIR', 'cc-wp-migration-dropbox-extension' );
}

// ===========================
// = Dropbox Extension Title =
// ===========================
if ( ! defined( 'CCWPMDE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMDE_PLUGIN_TITLE', 'Dropbox Extension' );
}

// ===========================
// = Dropbox Extension About =
// ===========================
if ( ! defined( 'CCWPMDE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMDE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/dropbox-extension/about' );
}

// =========================
// = Dropbox Extension Key =
// =========================
if ( ! defined( 'CCWPMDE_PLUGIN_KEY' ) ) {
	define( 'CCWPMDE_PLUGIN_KEY', 'ccwpmde_plugin_key' );
}

// ===========================
// = Dropbox Extension Short =
// ===========================
if ( ! defined( 'CCWPMDE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMDE_PLUGIN_SHORT', 'dropbox' );
}

// ==========================
// = FTP Extension Base Dir =
// ==========================
if ( defined( 'CCWPMFE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMFE_PLUGIN_BASEDIR', dirname( CCWPMFE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMFE_PLUGIN_BASEDIR', 'cc-wp-migration-ftp-extension' );
}

// =======================
// = FTP Extension Title =
// =======================
if ( ! defined( 'CCWPMFE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMFE_PLUGIN_TITLE', 'FTP Extension' );
}

// =======================
// = FTP Extension About =
// =======================
if ( ! defined( 'CCWPMFE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMFE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/ftp-extension/about' );
}

// =====================
// = FTP Extension Key =
// =====================
if ( ! defined( 'CCWPMFE_PLUGIN_KEY' ) ) {
	define( 'CCWPMFE_PLUGIN_KEY', 'ccwpmfe_plugin_key' );
}

// =======================
// = FTP Extension Short =
// =======================
if ( ! defined( 'CCWPMFE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMFE_PLUGIN_SHORT', 'ftp' );
}

// ===========================================
// = Google Cloud Storage Extension Base Dir =
// ===========================================
if ( defined( 'CCWPMCE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMCE_PLUGIN_BASEDIR', dirname( CCWPMCE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMCE_PLUGIN_BASEDIR', 'cc-wp-migration-gcloud-storage-extension' );
}

// ========================================
// = Google Cloud Storage Extension Title =
// ========================================
if ( ! defined( 'CCWPMCE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMCE_PLUGIN_TITLE', 'Google Cloud Storage Extension' );
}

// ========================================
// = Google Cloud Storage Extension About =
// ========================================
if ( ! defined( 'CCWPMCE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMCE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/google-cloud-storage-extension/about' );
}

// ======================================
// = Google Cloud Storage Extension Key =
// ======================================
if ( ! defined( 'CCWPMCE_PLUGIN_KEY' ) ) {
	define( 'CCWPMCE_PLUGIN_KEY', 'ccwpmce_plugin_key' );
}

// ========================================
// = Google Cloud Storage Extension Short =
// ========================================
if ( ! defined( 'CCWPMCE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMCE_PLUGIN_SHORT', 'gcloud-storage' );
}

// ===================================
// = Google Drive Extension Base Dir =
// ===================================
if ( defined( 'CCWPMGE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMGE_PLUGIN_BASEDIR', dirname( CCWPMGE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMGE_PLUGIN_BASEDIR', 'cc-wp-migration-gdrive-extension' );
}

// ================================
// = Google Drive Extension Title =
// ================================
if ( ! defined( 'CCWPMGE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMGE_PLUGIN_TITLE', 'Google Drive Extension' );
}

// ================================
// = Google Drive Extension About =
// ================================
if ( ! defined( 'CCWPMGE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMGE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/google-drive-extension/about' );
}

// ==============================
// = Google Drive Extension Key =
// ==============================
if ( ! defined( 'CCWPMGE_PLUGIN_KEY' ) ) {
	define( 'CCWPMGE_PLUGIN_KEY', 'ccwpmge_plugin_key' );
}

// ================================
// = Google Drive Extension Short =
// ================================
if ( ! defined( 'CCWPMGE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMGE_PLUGIN_SHORT', 'gdrive' );
}

// =====================================
// = Amazon Glacier Extension Base Dir =
// =====================================
if ( defined( 'CCWPMRE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMRE_PLUGIN_BASEDIR', dirname( CCWPMRE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMRE_PLUGIN_BASEDIR', 'cc-wp-migration-glacier-extension' );
}

// ==================================
// = Amazon Glacier Extension Title =
// ==================================
if ( ! defined( 'CCWPMRE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMRE_PLUGIN_TITLE', 'Amazon Glacier Extension' );
}

// ==================================
// = Amazon Glacier Extension About =
// ==================================
if ( ! defined( 'CCWPMRE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMRE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/amazon-glacier-extension/about' );
}

// ================================
// = Amazon Glacier Extension Key =
// ================================
if ( ! defined( 'CCWPMRE_PLUGIN_KEY' ) ) {
	define( 'CCWPMRE_PLUGIN_KEY', 'ccwpmre_plugin_key' );
}

// ==================================
// = Amazon Glacier Extension Short =
// ==================================
if ( ! defined( 'CCWPMRE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMRE_PLUGIN_SHORT', 'glacier' );
}

// ===========================
// = Mega Extension Base Dir =
// ===========================
if ( defined( 'CCWPMEE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMEE_PLUGIN_BASEDIR', dirname( CCWPMEE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMEE_PLUGIN_BASEDIR', 'cc-wp-migration-mega-extension' );
}

// ========================
// = Mega Extension Title =
// ========================
if ( ! defined( 'CCWPMEE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMEE_PLUGIN_TITLE', 'Mega Extension' );
}

// ========================
// = Mega Extension About =
// ========================
if ( ! defined( 'CCWPMEE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMEE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/mega-extension/about' );
}

// ======================
// = Mega Extension Key =
// ======================
if ( ! defined( 'CCWPMEE_PLUGIN_KEY' ) ) {
	define( 'CCWPMEE_PLUGIN_KEY', 'ccwpmee_plugin_key' );
}

// ========================
// = Mega Extension Short =
// ========================
if ( ! defined( 'CCWPMEE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMEE_PLUGIN_SHORT', 'mega' );
}

// ================================
// = Multisite Extension Base Dir =
// ================================
if ( defined( 'CCWPMME_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMME_PLUGIN_BASEDIR', dirname( CCWPMME_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMME_PLUGIN_BASEDIR', 'cc-wp-migration-multisite-extension' );
}

// =============================
// = Multisite Extension Title =
// =============================
if ( ! defined( 'CCWPMME_PLUGIN_TITLE' ) ) {
	define( 'CCWPMME_PLUGIN_TITLE', 'Multisite Extension' );
}

// =============================
// = Multisite Extension About =
// =============================
if ( ! defined( 'CCWPMME_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMME_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/multisite-extension/about' );
}

// ===========================
// = Multisite Extension Key =
// ===========================
if ( ! defined( 'CCWPMME_PLUGIN_KEY' ) ) {
	define( 'CCWPMME_PLUGIN_KEY', 'ccwpmme_plugin_key' );
}

// =============================
// = Multisite Extension Short =
// =============================
if ( ! defined( 'CCWPMME_PLUGIN_SHORT' ) ) {
	define( 'CCWPMME_PLUGIN_SHORT', 'multisite' );
}

// ===============================
// = OneDrive Extension Base Dir =
// ===============================
if ( defined( 'CCWPMOE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMOE_PLUGIN_BASEDIR', dirname( CCWPMOE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMOE_PLUGIN_BASEDIR', 'cc-wp-migration-onedrive-extension' );
}

// ============================
// = OneDrive Extension Title =
// ============================
if ( ! defined( 'CCWPMOE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMOE_PLUGIN_TITLE', 'OneDrive Extension' );
}

// ============================
// = OneDrive Extension About =
// ============================
if ( ! defined( 'CCWPMOE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMOE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/onedrive-extension/about' );
}

// ==========================
// = OneDrive Extension Key =
// ==========================
if ( ! defined( 'CCWPMOE_PLUGIN_KEY' ) ) {
	define( 'CCWPMOE_PLUGIN_KEY', 'ccwpmoe_plugin_key' );
}

// ============================
// = OneDrive Extension Short =
// ============================
if ( ! defined( 'CCWPMOE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMOE_PLUGIN_SHORT', 'onedrive' );
}

// =============================
// = pCloud Extension Base Dir =
// =============================
if ( defined( 'CCWPMPE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMPE_PLUGIN_BASEDIR', dirname( CCWPMPE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMPE_PLUGIN_BASEDIR', 'cc-wp-migration-pcloud-extension' );
}

// ==========================
// = pCloud Extension Title =
// ==========================
if ( ! defined( 'CCWPMPE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMPE_PLUGIN_TITLE', 'pCloud Extension' );
}

// ==========================
// = pCloud Extension About =
// ==========================
if ( ! defined( 'CCWPMPE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMPE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/pcloud-extension/about' );
}

// ========================
// = pCloud Extension Key =
// ========================
if ( ! defined( 'CCWPMPE_PLUGIN_KEY' ) ) {
	define( 'CCWPMPE_PLUGIN_KEY', 'ccwpmpe_plugin_key' );
}

// ==========================
// = pCloud Extension short =
// ==========================
if ( ! defined( 'CCWPMPE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMPE_PLUGIN_SHORT', 'pcloud' );
}

// ================================
// = Amazon S3 Extension Base Dir =
// ================================
if ( defined( 'CCWPMSE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMSE_PLUGIN_BASEDIR', dirname( CCWPMSE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMSE_PLUGIN_BASEDIR', 'cc-wp-migration-s3-extension' );
}

// =============================
// = Amazon S3 Extension Title =
// =============================
if ( ! defined( 'CCWPMSE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMSE_PLUGIN_TITLE', 'Amazon S3 Extension' );
}

// =============================
// = Amazon S3 Extension About =
// =============================
if ( ! defined( 'CCWPMSE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMSE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/amazon-s3-extension/about' );
}

// ===========================
// = Amazon S3 Extension Key =
// ===========================
if ( ! defined( 'CCWPMSE_PLUGIN_KEY' ) ) {
	define( 'CCWPMSE_PLUGIN_KEY', 'ccwpmse_plugin_key' );
}

// =============================
// = Amazon S3 Extension Short =
// =============================
if ( ! defined( 'CCWPMSE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMSE_PLUGIN_SHORT', 's3' );
}

// ================================
// = Unlimited Extension Base Dir =
// ================================
if ( defined( 'CCWPMUE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMUE_PLUGIN_BASEDIR', dirname( CCWPMUE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMUE_PLUGIN_BASEDIR', 'cc-wp-migration-unlimited-extension' );
}

// =============================
// = Unlimited Extension Title =
// =============================
if ( ! defined( 'CCWPMUE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMUE_PLUGIN_TITLE', 'Unlimited Extension' );
}

// =============================
// = Unlimited Extension About =
// =============================
if ( ! defined( 'CCWPMUE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMUE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/unlimited-extension/about' );
}

// ===========================
// = Unlimited Extension Key =
// ===========================
if ( ! defined( 'CCWPMUE_PLUGIN_KEY' ) ) {
	define( 'CCWPMUE_PLUGIN_KEY', 'ccwpmue_plugin_key' );
}

// =============================
// = Unlimited Extension Short =
// =============================
if ( ! defined( 'CCWPMUE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMUE_PLUGIN_SHORT', 'unlimited' );
}

// ==========================
// = URL Extension Base Dir =
// ==========================
if ( defined( 'CCWPMLE_PLUGIN_BASENAME' ) ) {
	define( 'CCWPMLE_PLUGIN_BASEDIR', dirname( CCWPMLE_PLUGIN_BASENAME ) );
} else {
	define( 'CCWPMLE_PLUGIN_BASEDIR', 'cc-wp-migration-url-extension' );
}

// =======================
// = URL Extension Title =
// =======================
if ( ! defined( 'CCWPMLE_PLUGIN_TITLE' ) ) {
	define( 'CCWPMLE_PLUGIN_TITLE', 'URL Extension' );
}

// =======================
// = URL Extension About =
// =======================
if ( ! defined( 'CCWPMLE_PLUGIN_ABOUT' ) ) {
	define( 'CCWPMLE_PLUGIN_ABOUT', 'https://ccwpmigration.xyz/products/url-extension/about' );
}

// =====================
// = URL Extension Key =
// =====================
if ( ! defined( 'CCWPMLE_PLUGIN_KEY' ) ) {
	define( 'CCWPMLE_PLUGIN_KEY', 'ccwpmle_plugin_key' );
}

// =======================
// = URL Extension Short =
// =======================
if ( ! defined( 'CCWPMLE_PLUGIN_SHORT' ) ) {
	define( 'CCWPMLE_PLUGIN_SHORT', 'url' );
}
